<?php

namespace App\Console;

use App\Models\User;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Mail\Message;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();

        $schedule->call(function () {
            $expiredUsers = User::expiredAthletes()->get();

            foreach ($expiredUsers as $expiredUser) {
                \Mail::raw('Expired passport from ' . $expiredUser, function ($message) {
                    $message->to(env('ADMIN_EMAIL'))->subject('Expired passport')->from(env('MAIL_FROM_ADDRESS'));
                });
            }
            
        })->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
