<?php

namespace App\Exports;

use App\Models\Event;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class LonglistExport implements FromView
{
    protected $event;

    function __construct($event) {
        $this->event = $event;
    }

    public function view(): View
    {
        return view('exports.longlist', [
            'event' => $this->event,
            'athletes' => $this->event->athletes,
            'trainers' => $this->event->trainers,
            'participants' => $this->event->participants,
        ]);
    }
}
