<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Airline;
use App\Models\Residence;
use App\Models\User;
use Illuminate\Http\Request;

class EndpointController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function userAccount(User $user) {
        return $user;
    }

    public function saveAirline(Request $request) {
        $airline = new Airline();
        $airline->name = $request->name;
        $airline->save();

        return [
            'message' => 'Airline added',
            'success' => true
        ];
    }

    public function saveResidence(Request $request) {
        $residence = new Residence();
        $residence->name = $request->name;
        $residence->type = "Hotel";
        $residence->save();

        return [
            'message' => 'Residence added',
            'success' => true
        ];
    }
}
