<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Athlete extends Model
{
    use HasFactory;

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'birth_date' => 'datetime:Y-m-d',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function organisations() {
        return $this->belongsToMany(Organisation::class);
    }

    public function awards() {
        return $this->belongsToMany(Award::class);
    }

    public function sponsors() {
        return $this->belongsToMany(Sponsor::class);
    }

    public function sportCategories() {
        return $this->belongsToMany(SportCategory::class);
    }

    public function outfits() {
        return $this->hasMany(Outfit::class);
    }

    public function healthRecords() {
        return $this->hasMany(HealthRecord::class);
    }
}
