<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class Event extends Model
{
    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'begin_date' => 'datetime:Y-m-d',
        'end_date' => 'datetime:Y-m-d',
    ];

    public function participants() {
        return $this->belongsToMany(User::class);
    }

    public function athletes() {
        return $this->belongsToMany(Athlete::class);
    }

    public function trainers() {
        return $this->belongsToMany(Trainer::class);
    }

    public function subSportCategories() {
        return $this->belongsToMany(SubSportCategory::class);
    }
}
