<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends \TCG\Voyager\Models\User
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'passport_expiration_date' => 'datetime:Y-m-d',
        'passport_issue_date' => 'datetime:Y-m-d',
        'id_expiration_date' => 'datetime:Y-m-d',
        'visa_issue_date' => 'datetime:Y-m-d',
        'visa_expiration_date' => 'datetime:Y-m-d',
    ];

    public function assignedTo() {
        return $this->belongsTo(User::class, 'assigned_to', 'id')->withDefault();
    }

    /**
     * Scope a query to only include none athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAdmins($query): void
    {
        $query->where('role_id', 1);
    }

    /**
     * Scope a query to only include none athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeTrainers($query): void
    {
        $query->where('role_id', 9);
    }

    /**
     * Scope a query to only include athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAthletes($query): void
    {
        $query->where('role_id', 10);
    }

    /**
     * Scope a query to only include athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeValidatedAthletes($query): void
    {
        $query->where('role_id', 10)->where('passport_expiration_date', '>', today());
    }

    /**
     * Scope a query to only include athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeExpiredAthletes($query): void
    {
        $query->where('role_id', 10)->where('passport_expiration_date', '<', today());
    }

    /**
     * Scope a query to only include none athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeNoneAthletes($query): void
    {
        $query->where('role_id', '!=', 10);
    }

    /**
     * Scope a query to only include none athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeComitees($query): void
    {
        $query->where('role_id', 7);
    }

    /**
     * Scope a query to only include none athlete users.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeLidbonden($query): void
    {
        $query->where('role_id', 8);
    }

    public function scopeVerified($query): void
    {
        $query->where('verified', 'yes');
    }
}
