@extends('voyager::master')

@section('page_title', "Athlete Stats")

@section('page_header')
    <div class="container-fluid" style="height: 100px; background-image: url('{{ asset("assets/images/5618236.jpg") }}'); background-repeat: no-repeat; background-size: cover; width: 105%">
    </div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div style="background-image: linear-gradient(to bottom, white, #d4d4d4); height: 80px; width: 101%">
            <div class="col-md-12">
                <h1 style="color: black;">{{ $athlete->firstname }} {{ $athlete->nickname ? '"' . $athlete->nickname . '"' : null }} {{ $athlete->lastname }}</h1>
            </div>
        </div>

        <br><br>
        <div class="col-md-6" style="">
            {{-- <img style="width: 700px; height: auto; padding: 10px; border: solid 1px;" src="https://c1.staticflickr.com/1/578/21820499801_7cb12b1043_b.jpg" alt=""> --}}
            <img style="width: 700px; height: auto; padding: 10px; border: solid 1px;" src="/storage/{{ ($athlete->profile) }}" alt="">
        </div>
        <div class="col-md-6">
            <div class="well">
                <table style="width: 100%">
                    <tr>
                        <td style="font-size: 1.8em;"><b>Nationality</b></td>
                        <td style="font-size: 1.8em;">{{ $athlete->nationality }}</td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em;"><b>Position</b></td>
                        <td style="font-size: 1.8em;">Defender</td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em;"><b>Height</b></td>
                        <td style="font-size: 1.8em;">{{ $athlete->height }}</td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em;"><b>Weight</b></td>
                        <td style="font-size: 1.8em;">{{ $athlete->weight }}</td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em;"><b>Sponsor</b></td>
                        <td style="font-size: 1.8em;">Coca Cola</td>
                    </tr>
                </table>
            </div>
            <div class="well">
                <h2 style="color: red; text-align: center;">Latest record:</h2>
                <table style="width: 100%">
                    <tr>
                        <td style="font-size: 1.8em; text-align: center;">June 28, 2016</td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em; text-align: center;"><b>1 - 1</b></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-md-6" style="margin-top: -60px">
            <div class="well">
                <h1>Biograpgy:</h1>
            </div>
            
            {!! $athlete->bio !!}
        </div>
        <div class="col-md-6">
            <div class="well">
                <h2 style="color: red; text-align: center;">Next match:</h2>
                <table style="width: 100%">
                    <tr>
                        <td style="font-size: 1.8em; text-align: center;"><b>14</b></td>
                        <td style="font-size: 1.8em; text-align: center;"><b>12</b></td>
                        <td style="font-size: 1.8em; text-align: center;"><b>33</b></td>
                        <td style="font-size: 1.8em; text-align: center;"><b>42</b></td>
                    </tr>
                    <tr>
                        <td style="font-size: 1.8em; text-align: center;">Days</td>
                        <td style="font-size: 1.8em; text-align: center;">Hours</td>
                        <td style="font-size: 1.8em; text-align: center;">Minutes</td>
                        <td style="font-size: 1.8em; text-align: center;">Sec</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="well" style="margin-left: 10px">
            <h1>Primary League:</h1>
        </div>
        <div style="margin-left: 10px">
            <div class="well">
                <table class="table table-striped">
                    <thead>
                      <tr>
                        <th scope="col">Season</th>
                        <th scope="col">Team</th>
                        <th scope="col">Goals</th>
                        <th scope="col">Assists</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <th>Last season</th>
                        <th>E-Sporter</th>
                        <th>5</th>
                        <th>3</th>
                      </tr>
                      <tr>
                        <th>Next season</th>
                        <th>E-Sporter</th>
                        <th>8</th>
                        <th>2</th>
                      </tr>
                    </tbody>
                  </table>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="well" style="margin-left: 10px">
            <h1>Events:</h1>
        </div>
        <div style="margin-left: 10px">
            <div class="well">
                <table class="table table-striped">
                    <thead>
                      <tr>
                        <th scope="col">Name</th>
                        <th scope="col">Season</th>
                        <th scope="col">Location</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <th>Last season</th>
                        <th>16 Nov 2023 - 27 Nov 2023</th>
                        <th>Paris</th>
                      </tr>
                    </tbody>
                  </table>
            </div>
        </div>
    </div>
    
</div>
    
@stop
