<table>
    <thead>
    <tr>
        <th>Username</th>
        <th>SPORTS</th>
        <th>NAME</th>
        <th>FIRST NAME</th>
        <th>DATE OF BIRTH</th>
        <th>GENDER</th>
        <th>ADDRESS</th>
        <th>PHONE NUMBER</th>
        <th>NATIONALITY</th>
        <th>PASSPORT NUMBER</th>
        <th>VALIDATION DATE</th>
        <th>EXPIRATION DATE</th>
        <th>VALID USA VISA</th>
        <th>VALIDATION DATE</th>
        <th>EXPIRATION DATE</th>
        <th>YELLOW FEVER VACCINATED</th>
        <th>COVID-19 VACCINATION</th>
        <th>TSHIRT SIZE</th>
        <th>TRACKSUIT SIZE</th>
        <th>DESCRIBE ALLERGIES IF ANY</th>
    </tr>
    </thead>
    <tbody>
        @foreach($athletes as $athlete)
            <tr>
                <td>{{ $athlete->user->name }}</td>
                <td>
                    @foreach ($athlete->sportCategories as $sportCategory)
                        @if ($loop->first)
                            {{ $sportCategory->name }}
                        @else
                        , {{ $sportCategory->name }}
                        @endif
                    @endforeach
                </td>
                <td>{{ $athlete->lastname }}</td>
                <td>{{ $athlete->firstname }}</td>
                <td>{{ $athlete->birth_date }}</td>
                <td>
                    @switch($athlete->gender)
                        @case('m')
                            Male
                            @break
                        @case('f')
                            Female
                            @break
                        @default
                            
                    @endswitch
                </td>
                <td>{{ $athlete->address }}</td>
                <td>{{ $athlete->mobile }}</td>
                <td>{{ $athlete->nationality }}</td>
                <td>{{ $athlete->user->passport_number }}</td>
                <td>{{ $athlete->user->passport_issue_date ? $athlete->user->passport_issue_date->format("d-M-Y") : null }}</td>
                <td>{{ $athlete->user->passport_expiration_date ? $athlete->user->passport_expiration_date->format("d-M-Y") : null }}</td>
                <td>{{ $athlete->user->visa_number }}</td>
                <td>{{ $athlete->user->visa_issue_date ? $athlete->user->visa_issue_date->format("d-M-Y") : null }}</td>
                <td>{{ $athlete->user->visa_expiration_date ? $athlete->user->visa_expiration_date->format("d-M-Y") : null }}</td>
                <td>{{ $athlete->yellow_fever !== "[]" ? "Yes" : "No" }}</td>
                <td>{{ $athlete->covid_vaccination !== "[]" ? "Yes" : "No" }}</td>
                <td>
                    @foreach ($athlete->outfits as $outfit)
                        @foreach (json_decode($outfit->sizes) as $size)
                            @if ($loop->first)
                                {{ $size }}
                            @else
                            , {{ $size }}
                            @endif
                        @endforeach
                    @endforeach
                </td>
                <td>
                    @foreach ($athlete->outfits as $outfit)
                        @foreach (json_decode($outfit->tracksuit_sizes) as $size)
                            @if ($loop->first)
                                {{ $size }}
                            @else
                            , {{ $size }}
                            @endif
                        @endforeach
                    @endforeach
                </td>
                <td>
                    {{-- @foreach ($athlete->healthRecords as $healthRecord)
                        @if ($loop->first)
                            {{ $healthRecord->examination }}
                        @else
                        , {{ $healthRecord->examination }}
                        @endif
                    @endforeach --}}
                    {{ $athlete->allergies }}
                </td>
            </tr>
        @endforeach
        
        @foreach($trainers as $trainer)
            <tr>
                <td>{{ $trainer->user->name }}</td>
                <td>
                    @foreach ($trainer->sportCategories as $sportCategory)
                        @if ($loop->first)
                            {{ $sportCategory->name }}
                        @else
                        , {{ $sportCategory->name }}
                        @endif
                    @endforeach
                </td>
                <td>{{ $trainer->lastname }}</td>
                <td>{{ $trainer->firstname }}</td>
                <td>{{ $trainer->birth_date }}</td>
                <td>
                    @switch($trainer->gender)
                        @case('m')
                            Male
                            @break
                        @case('f')
                            Female
                            @break
                        @default
                            
                    @endswitch
                </td>
                <td>{{ $trainer->address }}</td>
                <td>{{ $trainer->mobile }}</td>
                <td>{{ $trainer->nationality }}</td>
                <td>{{ $trainer->user->passport_number }}</td>
                <td>{{ $trainer->user->passport_issue_date ? $trainer->user->passport_issue_date->format("d-M-Y") : null }}</td>
                <td>{{ $trainer->user->passport_expiration_date ? $trainer->user->passport_expiration_date->format("d-M-Y") : null }}</td>
                <td>{{ $trainer->user->visa_number }}</td>
                <td>{{ $trainer->user->visa_issue_date ? $trainer->user->visa_issue_date->format("d-M-Y") : null }}</td>
                <td>{{ $trainer->user->visa_expiration_date ? $trainer->user->visa_expiration_date->format("d-M-Y") : null }}</td>
                <td>{{ $trainer->yellow_fever !== "[]" ? "Yes" : "No" }}</td>
                <td>{{ $trainer->covid_vaccination !== "[]" ? "Yes" : "No" }}</td>
                <td>
                    @foreach ($trainer->outfits as $outfit)
                        @foreach (json_decode($outfit->sizes) as $size)
                            @if ($loop->first)
                                {{ $size }}
                            @else
                            , {{ $size }}
                            @endif
                        @endforeach
                    @endforeach
                </td>
                <td>
                    @foreach ($trainer->outfits as $outfit)
                        @foreach (json_decode($outfit->tracksuit_sizes) as $size)
                            @if ($loop->first)
                                {{ $size }}
                            @else
                            , {{ $size }}
                            @endif
                        @endforeach
                    @endforeach
                </td>
                <td>
                    {{-- @foreach ($trainer->healthRecords as $healthRecord)
                        @if ($loop->first)
                            {{ $healthRecord->examination }}
                        @else
                        , {{ $healthRecord->examination }}
                        @endif
                    @endforeach --}}
                    {{ $trainer->allergies }}
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
