<!DOCTYPE html>
<html lang="{{ config('app.locale') }}" dir="{{ __('voyager::generic.is_rtl') == 'true' ? 'rtl' : 'ltr' }}">
    <head>
        <title>@yield('page_title', setting('admin.title') . " - " . setting('admin.description'))</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}"/>
        <meta name="assets-path" content="{{ route('voyager.voyager_assets') }}"/>

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,700" rel="stylesheet">

        <!-- Favicon -->
        <?php $admin_favicon = Voyager::setting('admin.icon_image', ''); ?>
        @if($admin_favicon == '')
            <link rel="shortcut icon" href="{{ voyager_asset('images/logo-icon.png') }}" type="image/png">
        @else
            <link rel="shortcut icon" href="{{ Voyager::image($admin_favicon) }}" type="image/png">
        @endif

        <!-- App CSS -->
        <link rel="stylesheet" href="{{ voyager_asset('css/app.css') }}">

        @if(__('voyager::generic.is_rtl') == 'true')
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-rtl/3.4.0/css/bootstrap-rtl.css">
            <link rel="stylesheet" href="{{ voyager_asset('css/rtl.css') }}">
        @endif

        @if(!empty(config('voyager.additional_css')))<!-- Additional CSS -->
            @foreach(config('voyager.additional_css') as $css)<link rel="stylesheet" type="text/css" href="{{ asset($css) }}">@endforeach
        @endif
        <style>
            b {
                font-weight: bold;
            }

            @media screen {
                div.divFooter {
                    display: none;
                }
            }
            @media print {
                div.divFooter {
                    position: fixed;
                    bottom: 0;
                }
            }
        </style>
    </head>
<body>
    <h3 class="text-center">SHORT LIST REPORT SUR - SURINAME</h3>
    <hr>
    <div style="display: flex;flex-direction: row;justify-content: space-around;">
        <img height="140px" src="{{ Voyager::image($admin_favicon) }}" alt="">
        <h3>{{ $event->name }}</h3>
    </div>
    <h3 class="text-center">
        @foreach ($sportCategories as $sportCategory)
            @if ($loop->first)
                {{ $sportCategory }}
            @else
            , {{ $sportCategory }}
            @endif
        @endforeach
    </h3>
    <hr>
    <b>List of people in the discipline</b>
    <hr>
    <table style="width: 100%">
        <thead>
            <tr>
                <th><b>Accreditation</b></th>
                <th><b>Given Name</b></th>
                {{-- <th><b>Family Name</b></th> --}}
                <th><b>Passport</b></th>
                <th><b>ID Expiry Date</b></th>
                <th><b>Function</b></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($event->participants as $participant)
                <td>{{ $participant->accreditation }}</td>
                <td>{{ $participant->name }}</td>
                {{-- <td></td> --}}
                <td>{{ $participant->passport_number }}</td>
                <td>{{ $participant->id_expiration_date }}</td>
                <td>{{ ucfirst($participant->role->name) }}</td>
            @endforeach
        </tbody>
    </table>
    <hr>
    <b>List of people with sport events</b>
    <hr>
    <table style="width: 100%">
        <thead>
            <tr style="border-bottom: 1px solid #eee">
                <th><b>Accreditation</b></th>
                <th><b>Given Name</b></th>
                <th><b>Family Name</b></th>
                <th><b>Date of birth</b></th>
                <th><b>Org</b></th>
                <th><b>Passport</b></th>
                <th><b>ID Expiry Date</b></th>
                <th><b>Function</b></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($event->athletes as $athlete)
                <tr style="border-bottom: 1px solid #eee">
                    <td>{{ $athlete->accreditation }}</td>
                    <td>{{ $athlete->firstname }}</td>
                    <td>{{ $athlete->lastname }}</td>
                    <td>{{ $athlete->birth_date }}</td>
                    <td>
                        @foreach ($athlete->organisations as $organisation)
                            @if ($loop->first)
                                {{ $organisation->name }}
                            @else
                            , {{ $organisation->name }}
                            @endif
                        @endforeach
                    </td>
                    <td>{{ $athlete->user->passport_expiration_date ? $athlete->user->passport_expiration_date->format('Y-M-d') : null }}</td>
                    <td>{{ $athlete->user->id_expiration_date ? $athlete->user->id_expiration_date->format('Y-M-d') : null }}</td>
                    <td>Athlete</td>
                </tr>
            @endforeach
            
            @foreach ($event->trainers as $trainer)
                <tr style="border-bottom: 1px solid #eee">
                    <td>{{ $trainer->accreditation }}</td>
                    <td>{{ $trainer->firstname }}</td>
                    <td>{{ $trainer->lastname }}</td>
                    <td>{{ $trainer->birth_date }}</td>
                    <td>
                        @foreach ($trainer->organisations as $organisation)
                            @if ($loop->first)
                                {{ $organisation->name }}
                            @else
                            , {{ $organisation->name }}
                            @endif
                        @endforeach
                    </td>
                    <td>{{ $trainer->user->passport_expiration_date ? $trainer->user->passport_expiration_date->format('Y-M-d') : null }}</td>
                    <td>{{ $trainer->user->id_expiration_date ? $trainer->user->id_expiration_date->format('Y-M-d') : null }}</td>
                    <td>Trainer</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <br>

    <b>Sport events: {{ $event->subSportCategories->count() }}</b>

    <ol>
        @foreach ($event->subSportCategories as $subSportCategory)
            <li>{{ $subSportCategory->name }}</li>
        @endforeach
    </ol>

    <hr>

    <h4 class="text-center">
        <b>TOTAL ATHLETES: {{ $event->athletes->count() + $event->trainers->count() }}</b>
    </h4>

    <br>

    <div class="signature">
        <p><b>Date:</b> {{ \Carbon\Carbon::now()->format('l, d-M-Y, H:i:s') }}</p>
    
        <table style="width: 100%">
            <thead>
                <tr>
                    <th><b>Org Responsible</b></th>
                    <th><b>INSCRIPTION TEAM</b></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Name:</td>
                    <td>Name:</td>
                </tr>
                <tr>
                    <td>Signature:</td>
                    <td>Signature:</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="divFooter"><center style="color: gray;">Report generated by SOC @ {{ now()->format('Y') }}</center></div>
    <script>
        window.print();
        window.location = '/events';
    </script>
</body>
</html>