<?php

use App\Http\Controllers\AccomodationController;
use App\Http\Controllers\AirlineController;
use App\Http\Controllers\Api\EndpointController;
use App\Http\Controllers\AthleteController;
use App\Http\Controllers\AwardController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\HealthRecordController;
use App\Http\Controllers\OrganisationController;
use App\Http\Controllers\OutfitController;
use App\Http\Controllers\ResidenceController;
use App\Http\Controllers\SponsorController;
use App\Http\Controllers\SportCategoryController;
use App\Http\Controllers\TrainerController;
use App\Http\Controllers\TravelController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Voyager::routes();

Route::get('/athletes/{athlete}/stats', [AthleteController::class, 'stats']);
Route::get('/exports/users', [UserController::class, 'export']);
Route::get('/exports/events', [EventController::class, 'export']);
Route::get('/exports/sport_categories', [SportCategoryController::class, 'export']);
Route::get('/exports/organisations', [OrganisationController::class, 'export']);
Route::get('/exports/trainers', [TrainerController::class, 'export']);
Route::get('/exports/athletes', [AthleteController::class, 'export']);
Route::get('/exports/travels', [TravelController::class, 'export']);
Route::get('/exports/sponsors', [SponsorController::class, 'export']);
Route::get('/exports/awards', [AwardController::class, 'export']);
Route::get('/exports/accomodations', [AccomodationController::class, 'export']);
Route::get('/exports/outfits', [OutfitController::class, 'export']);
Route::get('/exports/health_records', [HealthRecordController::class, 'export']);
Route::get('/exports/airlines', [AirlineController::class, 'export']);
Route::get('/exports/residences', [ResidenceController::class, 'export']);

Route::get('/hook', [ResidenceController::class, 'hook']);
Route::get('/send', [ResidenceController::class, 'send']);

Route::get('/endpoints/user/{user}', [EndpointController::class, 'userAccount']);
Route::post('/api/save_airline', [EndpointController::class, 'saveAirline']);
Route::post('/api/save_residence', [EndpointController::class, 'saveResidence']);

Route::get('shortlist/{event}', [EventController::class, 'shortlist']);
Route::get('longlist/{event}', [EventController::class, 'longlist']);
